  '' RAM IC test
  '' 23LC1024 RAM IC on SPI bus
  OPTION EXPLICIT
  DIM BUCKET AS INTEGER                       'for dummy reads
  SPI OPEN 20000000, 0, 8                     'manually open SPI
  CONST RAM_CS = 4
  SETPIN RAM_CS, DOUT
  PIN(RAM_CS)=1       ''CS HIGH
  SETRAMMODE(64)      ''sequential mode
  DIM A,I AS INTEGER
  
  DO
    PRINT "READ:"
    STARTRAMREAD(0)         'start at address 0
    FOR I = 0 to 30
      PRINT RAMREAD();" ";
    NEXT I
    ENDRAMREAD()
    PRINT
    PAUSE 1000
    
    PRINT "WRITE:"
    STARTRAMWRITE(0)
    FOR I = 0 to 30
      A= TIMER and 255
      RAMWRITE(A)
      PRINT A;" ";
      PAUSE 1
    NEXT I
    ENDRAMWRITE()
    PRINT
    PAUSE 1000
  LOOP
END
  
FUNCTION READRAMBYTE(A AS INTEGER)  ''read a single byte from A
  STARTRAMREAD(A)
  READRAMBYTE= RAMREAD()
  ENDRAMREAD()
END FUNCTION
  
SUB WRITERAMBYTE(A AS INTEGER, D AS INTEGER)  ''write a single byte D to A
  STARTRAMWRITE(A)
  RAMWRITE(D)
  ENDRAMWRITE()
END SUB
  
SUB SETRAMMODE(D AS INTEGER)    ''set RAM mode to D, 64=> Sequential, 0=> byte, 128=> page
  PIN(RAM_CS)=0       ''CS LOW
  BUCKET = SPI(1)     ''set mode
  BUCKET = SPI(D)
  PIN(RAM_CS)=1       ''CS HIGH
END SUB
  
SUB STARTRAMREAD(A AS INTEGER)    ''start read transaction at address A
  PIN(RAM_CS)=0       ''CS LOW
  BUCKET = SPI(3)     ''read
  BUCKET = SPI((A\65536) AND 255)
  BUCKET = SPI((A\256) AND 255)
  BUCKET = SPI(A AND 255)
  'note CS is not raised- cannot do other things on SPI till read ends
END SUB
  
FUNCTION RAMREAD()
  RAMREAD=SPI(0)     ''dummy
END FUNCTION
  
SUB ENDRAMREAD()
  PIN(RAM_CS)=1       ''CS HIGH
END SUB
  
SUB STARTRAMWRITE(A AS INTEGER)    ''start write transaction at address A
  PIN(RAM_CS)=0       ''CS LOW
  BUCKET = SPI(2)     ''write
  BUCKET = SPI((A\65536) AND 255)
  BUCKET = SPI((A\256) AND 255)
  BUCKET = SPI(A AND 255)
  'note CS is not raised- cannot do other things on SPI till read ends
END SUB
  
SUB RAMWRITE(D AS INTEGER)
  BUCKET=SPI(D)     ''dummy
END SUB
  
SUB ENDRAMWRITE()
  PIN(RAM_CS)=1       ''CS HIGH
END SUB
